#include <iostream>
#include <unordered_map>
#include <vector>
using namespace std;

struct Point {
    int x, y;
};

int main() {
    int n;
    cin >> n;
    
    vector<Point> points(n);
    for (int i = 0; i < n; i++) {
        cin >> points[i].x >> points[i].y;
    }
    
    long long totalGreetings = 0;
    unordered_map<string, int> visited;
    
    for (int i = 0; i < n; i++) {
        int x = points[i].x;
        int y = points[i].y;
        
        pair<int, int> moves[4] = {
            {x + 1, y},
            {x - 1, y},
            {x, y + 1},
            {x, y - 1}
        };
        
        for (int j = 0; j < 4; j++) {
            string key = to_string(moves[j].first) + "," + to_string(moves[j].second);
            totalGreetings += visited[key];
        }
        
        for (int j = 0; j < 4; j++) {
            string key = to_string(moves[j].first) + "," + to_string(moves[j].second);
            visited[key]++;
        }
    }
    
    cout << totalGreetings << endl;
    
    return 0;
}